/*
 * Decompiled with CFR 0.152.
 */
package ecrans;

import base.Ecran;
import base.Outil;
import base.Style;
import ecrans.EcranLancementCourse;
import ecrans.EcranListeCourses;
import ecrans.EcranParticipants;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.text.SimpleDateFormat;
import java.util.Date;
import javax.swing.AbstractButton;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JPanel;
import ressources.Images;
import special.PanelInformations;

public class EcranAccueil
extends Ecran
implements ActionListener,
Runnable {
    private static final long serialVersionUID = 1L;
    private static final String[] MESSAGES = new String[]{new SimpleDateFormat("EEEEEEEEEEE dd MMMMMMMMMMM yyyy").format(new Date()), "Logiciel d\u00e9velopp\u00e9 par Alexis Deprez", "contact : deprez.alexis@laposte.net"};
    private static final String[] DESCRIPTIONS = new String[]{"<u>1. Gestion des participants</u><br/>Cr\u00e9er ou modifier des listes de participants (Fichiers CSV). Il est ensuite possible de les inscrire \u00e0 une course.", "<u>2. Gestion des courses</u><br/>Cr\u00e9er ou modifier une course. Une fois termin\u00e9e, il est possible de consulter les r\u00e9sultats de celles-ci.", "<u>3. Lancer une course</u><br/>Cliquez ici pour d\u00e9marrer une nouvelle course."};
    private static EcranAccueil instance;
    private final AbstractButton participants;
    private final AbstractButton preparer;
    private final AbstractButton course;
    private int y;
    private int i;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static EcranAccueil getInstance() {
        Class<EcranParticipants> clazz = EcranParticipants.class;
        synchronized (EcranParticipants.class) {
            if (instance == null) {
                instance = new EcranAccueil();
            }
            // ** MonitorExit[var0] (shouldn't be in output)
            return instance;
        }
    }

    private EcranAccueil() {
        super("fonds/img.jpg");
        this.setMax(false);
        this.setLayout(new BorderLayout());
        JPanel p = new JPanel();
        p.setLayout(new GridLayout());
        p.setOpaque(false);
        this.participants = new JButton("  G\u00e9rer les participants", Images.getIcone("divers/icone.png", 64));
        p.add(Style.font(this.participants, true));
        this.preparer = new JButton("  G\u00e9rer les courses", Images.getIcone("divers/prepare.png", 64));
        p.add(Style.font(this.preparer, true));
        this.course = new JButton("  Lancer une course", Images.getIcone("divers/ok.png", 64));
        p.add(Style.font(this.course, true));
        this.participants.addActionListener(this);
        this.preparer.addActionListener(this);
        this.course.addActionListener(this);
        this.add((Component)p, "South");
        this.add(new PanelInformations(DESCRIPTIONS, this.participants, this.preparer, this.course));
        new Thread(this).start();
    }

    @Override
    public String getTitre() {
        return "Accueil";
    }

    @Override
    public void paintComponent(Graphics g) {
        g.fillRect(0, 0, this.getWidth(), this.getHeight());
        super.paintComponent(g);
        String s = MESSAGES[this.i % MESSAGES.length];
        g.setFont(Style.TITRE);
        g.setColor(Color.WHITE);
        g.drawString(s, (this.getWidth() - g.getFontMetrics().stringWidth(s)) / 2, this.y);
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (e.getSource() == this.participants) {
            this.changer(EcranParticipants.getInstance());
        } else if (e.getSource() == this.preparer) {
            this.changer(EcranListeCourses.getInstance());
        } else if (e.getSource() == this.course) {
            this.changer(EcranLancementCourse.getInstance());
        }
    }

    @Override
    public void run() {
        boolean up = false;
        while (true) {
            Outil.wait(42);
            this.repaint();
            this.y += up ? -1 : 1;
            if (up) {
                if (this.y > -10) continue;
                up = !up;
                ++this.i;
                continue;
            }
            if (this.y < 20) continue;
            up = !up;
            Outil.wait(2500);
        }
    }

    @Override
    public JComponent[] getMenu() {
        return new JComponent[0];
    }
}

